.cseg
; ***********************************************************************************************
;	Initialisierung:			(c) 2024 by DC7GB unter: BY-NC-SA 4.0
; ***********************************************************************************************


INIT:		ldi	temp,(1<<PRUSI)		;; USI
		out	PRR,temp		;; ...deaktivieren
		ldiw	Y,1			;; CALBYTE-Adresse im EEPROM
		rcall	eeread			;; CALBYTE aus EEPROM
		cpi	temp,$ff		;; EEPROM gelscht?
		breq	init_pll		;; ja, RC-Oszillator nicht ndern...
		tst	temp			;; EEPROM-Byte auf 0?
		breq	init_pll		;; ja, RC-Oszillator nicht ndern...
		out	OSCCAL,temp		;; CALBYTE fr 8 MHz setzen
; PLL ein:
INIT_PLL:	ldi	temp,(1<<PLLE)		;; 64 MHz PLL
		out	PLLCSR,temp		;; ...aktivieren
		rcall	wait100us		;; warte auf PLL-Lockin

; ----------------------------------------------
; Ports initialisieren:

		ldi	temp,DRA		;; PortA einstellen
		out	DDRA,temp
		ldi	temp,PULUPA		;; Pull-up an B-Eingngen aktivieren
		out	PORTA,temp
;
		ldi	temp,DRB		;; PortB einstellen
		out	DDRB,temp
.ifndef	_SPEEDTEST
		ldi	temp,PULUPB		;; Pull-up an B-Eingngen aktivieren
		out	PORTB,temp
.else
		cbi	PORTB,PDMOUT		;; Bus-Keeper-Ausgnge 
		cbi	PORTB,PRMOUT_N		;; ... deaktivieren
SPEEDLOOP:	sbi	PINB,TEST		;; TEST-Pin MP7 wechseln ergibt f = 2 MHz
		rjmp	speedloop		;; endlos...
.endif

; ----------------------------------------------
; Timer0 fr ADCTAKT:
	
		ldi	temp,0b00000001		;; CTC
		out	TCCR0A,temp		;; ...setzen
		ldi	temp,0b00000010		;; Prescaler :8
		out	TCCR0B,temp		;; ...setzen
		ldi	temp,TICS0		;; Timerkonstante
		out	OCR0A,temp		;; ...setzen
		ldi	temp,(1<<OCIE0A)	;; Interrupt bei
		out	TIMSK,temp		;; ...OCR0A-Match

; ----------------------------------------------
; Timer1 fr PDM an OC1B (Pin 4)

PLLWAIT:	in	temp,PLLCSR		;; 64 MHz-PLL
		sbrs	temp,PLOCK		;; ...eingerastet?
		rjmp	pllwait			;; nein...
		ldi	temp,(1<<PCKE)		;; Async-Clock
		out	PLLCSR,temp		;; ...setzen
;
		ldi	temp,0b00010001		;; OC1B: CLR on Match, Enable PDM-B
		out	TCCR1A,temp		;; ...setzen
		ldi	temp,0b00000001		;; DT-Prescale 0 / PCK: 64 MHz 
		out	TCCR1B,temp		;; ...setzen
		ldi	temp,0b00000000		;; Fast PDM @ TOP=OCR1C
		out	TCCR1D,temp		;; ..setzen
		ldi	temp,high(PDMAX)	;; setze
		out	TC1H,temp		;; ...den
		ldi	temp,low(PDMAX)		;; ...hchsten
		out	OCR1C,temp		;; ...PD-Zhlerstand
		ldi	temp,(DEADH<<4)|DEADL	;; Totzeit
		out	DT1,temp		;; ..einstellen

; ----------------------------------------------
; ADC fr ADC0/ADC1:

		ldi	temp,0b10001100		;; Referenz = 1,1V, ADLAR=right, ADC0/ADC1 v=1
		out	ADMUX,temp		;; ...einstellen
		ldi	temp,0b10101100		;; ADC ein, AutoTrigger, ADI, CLK:16 = 1 MHz
		out	ADCSRA,temp		;; ...einstellen
		ldi	temp,0b10000011		;; Bin, v=1, REFS2, MUX5, Trigger: TC0 Match A
		out	ADCSRB,temp		;; ...einstellen
		ldi	temp,(1<<ADC1D)|\
			     (1<<ADC0D)		;; ADC0/ADC1 vom Digital-Input
		out	DIDR0,temp		;; ...trennen

; ----------------------------------------------
; RAM und Register initialisieren:

		clr	flags0
		ldiw	Z,(2*SINTAB)		;; Zeiger in  Sinus-Tabelle
		stsw	sinp,Z			;; ...aablegen
		ldi	temp,SINSAMP		;; Samples in der Sinus-Tabelle
		sts	sinanz,temp		;; ...speichern
		sei				; Interrupts frei geben
; -------------
		ret

